<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PaymentMethod;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;

class PaymentMethodController extends Controller
{
    //
    public function allPaymentMethod() {
        $allData = PaymentMethod::all();
        return view('admin.paymentmethod.payment_method_all',compact('allData'));
    }
    // End of method

    public function addPaymentMethod() {
        return view('admin.paymentmethod.payment_method_add');
    }
    // End of method

    public function storePaymentMethod(Request $request) {

        PaymentMethod::insert([
            'name' => $request->name,
            'created_by' => Auth::user()->id,
            'created_at' => Carbon::now(),
        ]);

        $notification = array(
            'message' => 'Payment Method added successfully',
            'alert-type' => 'success',
        );
        return redirect()->route('paymentmethods.all')->with($notification);
    }
    // End of method

    public function editPaymentMethod($id) {
        $paymentmethod = PaymentMethod::findOrFail($id);
        return view('admin.paymentmethod.payment_method_edit', compact('paymentmethod'));
    }

    public function updatePaymentMethod(Request $request) {

        $request_id = $request->id;
        $unit = PaymentMethod::findOrFail($request_id)->update([
            'name' => $request->name,
            'updated_by' => Auth::user()->id,
            'updated_at' => Carbon::now(),
        ]);

        $notification = array(
            'message' => 'Payment Method Updated successfully',
            'alert-type' => 'success',
        );
        return redirect()->route('paymentmethods.all')->with($notification);
    } // End of method

    public function deletePaymentMethod($id) {

        PaymentMethod::findOrFail($id)->delete();

        $notification = array(
            'message' => 'Payment Method deleted successfully',
            'alert-type' => 'success',
        );
        return redirect()->route('paymentmethods.all')->with($notification);
    }
    // End of method
}
