<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\UserM;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;

class User extends Controller
{
    //
    public function allUsers() {
        $allusers = User::all();
        return view('admin/users/users_all', compact('allusers'));
    }

    public function addUser() {
        return view('admin/users/users_add');
    }

    public function userStore(Request $request) {

        $validateData = $request->validate([
            'name' => 'required',
            'sname' => 'required',
            'lname' => 'required',
            'mobile_no' => 'required|regex:/0[6-9][0-9]{8}/',
            'email' => 'required',
            'address' => 'required',
            'membership_no' => 'required',
        ]);


        User::insert([
            'name' => $request->name,
            'sname' => $request->sname,
            'lname' => $request->lname,
            'email' => $request->email,
            'mobile_no' => $request->mobile_no,
            'address' => $request->address,
            'item' => $request->item,
            'created_by' => Auth::user()->id,
            'created_at' => Carbon::now(),
        ]);
        $notification = array(
            'message' => 'User added successfully',
            'alert-type' => 'success',
        );
        return redirect()->route('users.all')->with($notification);
    } // End of method
}
